package aop.contracts.invariants;

import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;

public class InvariantInterceptor implements Interceptor {

	public String getName() {
		return "InvariantInterceptor";
	}

	public Object invoke(Invocation invocation) throws Throwable {
		Object rsp = invocation.invokeNext();

		MethodInvocation methodInvocation = (MethodInvocation)invocation;
		Method method = methodInvocation.getMethod();
		Object target = methodInvocation.getTargetObject();
		int etat =
			target.getClass().getDeclaredField("state").getInt(target);

		if (etat != 0) {
			throw new Error("Litige sur l'invariant de classe.");
		}
		return rsp;
	}
}
