package aop.contracts.preconditions;

import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class PreConditionInterceptor implements Interceptor {

	public String getName() {
		return "PreConditionInterceptor";
	}

	public Object invoke(Invocation invocation) throws Throwable {
		MethodInvocation methodInvocation = (MethodInvocation)invocation;
		Method method = methodInvocation.getMethod();
		Double parameter = (Double) methodInvocation.getArguments()[0];
		if (parameter.doubleValue() < 0) {
			StringBuffer errorMsg = new StringBuffer();
			errorMsg.append("Litige sur la pr-condition de la mthode sqrt. Le paramtre a une valeur ngative (");
			errorMsg.append(parameter);
			errorMsg.append(").");
			throw new Error(errorMsg.toString());
		}		
		return invocation.invokeNext();
	}
}
