package aop.management.jmx.mixin;

public class StatsMBeanMixin implements StatsMBean {
	private Stats advised;
	
	public StatsMBeanMixin(Object p) {
		advised = (Stats)p;
	}
	
	public int getMOrders() {
		return advised.getOrders();
	}
	
	public float getMTotalAmount() {
		return advised.getTotalAmount();
	}
	
	public float getMeanOrderAmount() {
		if (advised.getOrders() > 0) {
			return advised.getTotalAmount()/advised.getOrders();
		} else {
			return 0;
		}
	}
	
	public String getMStatus() {
		return advised.getStatus();
	}
	
	public void mReset() {
		advised.reset();
	}
}
