package aop.patterns.singleton;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;

public class SingletonInterceptor implements Interceptor {

	private Object singleton;
		
	public String getName() {
		return "SingletonInterceptor";
	}

	public Object invoke(Invocation invocation) throws Throwable {
		if (singleton==null) {
			System.out.println("une fois et une seule !");
			singleton = invocation.invokeNext();	
		}
		return singleton;
	}
}
