package aop.tests.cover;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class CoverRecorderInterceptor implements Interceptor, XmlLoadable {
	private PrintWriter out;
	
	public String getName() {
		return "CoverRecorderInterceptor";
	}

	public void importXml(Element parameter) {
		Element t =	(Element) parameter.getElementsByTagName("record-file").item(0);
		String fileName = "";
		if (t != null) {
			fileName = t.getAttribute("value");
			if ("".equals(fileName)){
				throw new RuntimeException("Paramtre value du tag record-file absent dans jboss-aop.xml");
			}
		} else {
			throw new RuntimeException("Tag record-file absent dans jboss-aop.xml");
		}
		try {
			FileOutputStream stream = new FileOutputStream(fileName);
			out = new PrintWriter(stream);
		} catch (FileNotFoundException e) {
			throw new RuntimeException("Le fichier de sortie du recorder est inaccessible");
		}
		out.println("Call type,Class,Name,Return / Type,parameters,exceptions");
	}

	public void recordMethodCall(String className,String methodName,Class returnType,Class[] parameters,Class[] exceptions) {
		out.print(className);
		out.print(',');
		out.print(methodName);
		out.print(',');
		if (returnType == null) {
			out.print("N/A"); 
		} else if (returnType.isArray()) {
			out.print(returnType.getComponentType());
			out.print("[]");
		} else {
			out.print(returnType.getName());	
		}
		out.print(',');
		StringBuffer temp = new StringBuffer();
		for (int i = 0; i < parameters.length; i++) {
			if (parameters[i].isArray()) {
				temp.append(parameters[i].getComponentType().getName());
				temp.append("[]");
			} else {
				temp.append(parameters[i].getName());	
			}
			temp.append(';');
		}
		if (temp.length() > 0) {
			temp.deleteCharAt(temp.length()-1);
			out.print(temp);
		}
		out.print(',');
		temp = new StringBuffer();
		for (int i = 0; i < exceptions.length; i++) {
			temp.append(exceptions[i].getName());
			temp.append(';');
		}
		if (temp.length() > 0) {
			temp.deleteCharAt(temp.length()-1);
			out.print(temp);
		}
	}
	
	public Object invoke(Invocation invocation) throws Throwable {
		String filter = (String) invocation.getMetaData("cover", "filter");
		if (filter != null && filter.equals("true")) {
			return invocation.invokeNext();
		}

		Object rsp = invocation.invokeNext();
			
		if (invocation instanceof MethodInvocation) {
			MethodInvocation methodInvocation = (MethodInvocation)invocation;
			Method method = methodInvocation.getMethod();
			String className = method.getDeclaringClass().getName();
			String methodName = method.getName();
			Class returnType = method.getReturnType();
			Class[] parameters = method.getParameterTypes();
			Class[] exceptions = method.getExceptionTypes();
			out.print("Method call,");
			recordMethodCall(className,methodName,returnType,parameters,exceptions);
		} else if (invocation instanceof ConstructorInvocation) {
			ConstructorInvocation constructorInvocation = (ConstructorInvocation)invocation;
			Constructor constructor = constructorInvocation.getConstructor();
			String className = constructor.getDeclaringClass().getName();
			String methodName = "N/A";
			Class returnType = null;
			Class[] parameters = constructor.getParameterTypes();
			Class[] exceptions = constructor.getExceptionTypes();
			out.print("Constructor call,");
			recordMethodCall(className,methodName,returnType,parameters,exceptions);
		} else if (invocation instanceof FieldInvocation) {
			if (invocation instanceof FieldReadInvocation) {
				out.print("Field read access,");
			} else {
				out.print("Field write access,");
			}
			FieldInvocation fieldInvocation = (FieldInvocation)invocation;
			Field field = fieldInvocation.getField();
			out.print(field.getDeclaringClass().getName());
			out.print(',');
			out.print(field.getName());
			out.print(',');
			out.print(field.getType());
		}
			
		out.println();
		out.flush();
	
		return rsp;
	}
	
	protected void finalize() throws Throwable {
		super.finalize();
		out.close();
	}
}
