package aop.tests.regression;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class RegressionRecorderInterceptor implements Interceptor, XmlLoadable {
	private PrintWriter out;
	private String version;

	public String getName() {
		return "RegressionRecorderInterceptor";
	}

	public void importXml(Element parameter) {
		Element t =
			(Element) parameter.getElementsByTagName("record-file").item(0);
		String fileName = "";
		if (t != null) {
			fileName = t.getAttribute("value");
			if ("".equals(fileName)){
				throw new RuntimeException("Paramtre value du tag record-file absent dans jboss-aop.xml");
			}
		} else {
			throw new RuntimeException("Tag record-file absent dans jboss-aop.xml");
		}
		t = (Element) parameter.getElementsByTagName("version").item(0);
		if (t!=null) {
			version = t.getAttribute("value");
			if ("".equals(version)) {
				throw new RuntimeException("Paramtre value du tag version absent dans jboss-aop.xml");
			}
		} else {
			throw new RuntimeException("Tag version absent dans jboss-aop.xml");
		}
		try {
			FileOutputStream stream = new FileOutputStream(fileName,true);
			out = new PrintWriter(stream);
		} catch (FileNotFoundException e) {
			throw new RuntimeException("Le fichier de sortie du recorder est inaccessible");
		}
		if (version.equals("1")) {
			out.println("Version,Class Name,Method Name,Response,Parameters,Exception");
		}
	}

	private String getValue(Object o) {
		if (!o.getClass().isArray()) {
			return Integer.toString(o.hashCode());
		} else {
			StringBuffer value = new StringBuffer();
			Object[] temp = (Object[]) o;
			for (int i=0;i<temp.length;i++) {
				value.append(getValue(temp[i]));
				value.append('|');
			}
			return value.toString();
		}
	}
	
	public Object invoke(Invocation invocation) throws Throwable {
		String filter = (String) invocation.getMetaData("regression", "filter");
		
		if ((!(invocation instanceof MethodInvocation))
			|| (filter != null && filter.equals("true"))) {
			return invocation.invokeNext();
		}

		Object response = null;
		Throwable exception = null;
		
		try {
			response = invocation.invokeNext();
		}
		catch (Throwable e){
			exception = e;
		}

		MethodInvocation methodInvocation = (MethodInvocation)invocation;
		Method method = methodInvocation.getMethod();
	
		String className = method.getDeclaringClass().getName();
		String methodName = method.getName();
		Object[] parameters = methodInvocation.getArguments();
				
		out.print(version);
		out.print(',');
		out.print(className);
		out.print(',');
		out.print(methodName);
		out.print(',');
		if (response!=null) {
			out.print(getValue(response));
		} else if (method.getReturnType().isAssignableFrom(java.lang.Void.TYPE)) {
			out.print("void");
		} else {
			out.print("null");
		}
		out.print(',');
		StringBuffer temp = new StringBuffer();
		for (int i = 0; i < parameters.length; i++) {
			if (parameters[i]!=null) {
				temp.append(getValue(parameters[i]));
			} else {
				temp.append("null");
			}
			temp.append(';');
		}
		if (temp.length()>0) {
			temp.deleteCharAt(temp.length()-1);
			out.print(temp);
		}
		if (exception!=null){
			out.print(',');
			out.print("throws ");
			out.print(exception.getClass().getName());
		}
		out.println();
		out.flush();
		
		return response;
	}
	
	protected void finalize() throws Throwable {
		super.finalize();
		out.close();
	}	
}
