#!/bin/sh

echo "------------------------------------------------------------"
echo "- La programmation orientee aspect pour Java/J2EE          -"
echo "- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -"
echo "- Editions Eyrolles                                        -"
echo "-                                                          -"
echo "- Partie III  : Applications de la POA                        -"
echo "- Chapitre 10 : Serveurs d'applications et POA                                         -"
echo "------------------------------------------------------------"

echo "--------------------------------------------"
echo "- Application: PersistenceExample        -"
echo "- Aspects:      Persistence -"
echo "--------------------------------------------"

if [ -f $JAVA_HOME/bin/java ]
then
    if [ -f $JAC_HOME/jac.jar ]
    then
        echo ---- Compilation ----

	cd ../..

        "$JAVA_HOME/bin/javac" -classpath "$JAC_HOME/jac.jar:$JAC_HOME/lib/aopalliance.jar:$CLASSPATH" -d classes src/aop/as/hibernate/*.java

        "$JAVA_HOME/bin/javac" -classpath "classes:$JAC_HOME/jac.jar:$JAC_HOME/lib/aopalliance.jar:$CLASSPATH" -d classes src/aop/as/persistence/*.java

        echo ---- Execution ----

        "$JAVA_HOME/bin/java" -classpath "classes:$JAC_HOME/jac.jar:$CLASSPATH" org.objectweb.jac.core.Jac -R . -C classes:src PersistenceExample.jac
    else
        echo "JAC n'a pas ete trouve."
        echo "Positionner la variable d'environnement JAC_HOME dans le fichier env.sh"
    fi
else
    echo "Java n'a pas ete trouve."
    echo "Positionner la variable d'environnement JAVA_HOME dans le fichier env.sh"
fi
