// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.hibernate;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Interaction;
import org.objectweb.jac.core.Wrapper;

/**
 * Wrapper grant les dbuts de session Hibernate
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class BeginPersistentSessionWrapper extends Wrapper {
    
    public BeginPersistentSessionWrapper(AspectComponent ac) {
        super(ac);
    }
    
    public Object invoke( MethodInvocation invocation ) {
        Interaction interaction = (Interaction) invocation;
		HibernateHelper helper = HibernateHelper.getInstance();
		helper.openSessionAndBeginTx();
		return proceed(interaction);
    }

    public Object construct(ConstructorInvocation invocation)
        throws Throwable {
        throw new Exception("Ce wrapper ne supporte pas le wrapping de constructeur");
    }
}
