// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.hibernate;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Interaction;
import org.objectweb.jac.core.Wrapper;

/**
 * Wrapper grant les fins de session Hibernate
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class EndPersistentSessionWrapper extends Wrapper {
   
    public EndPersistentSessionWrapper(AspectComponent ac) {        
        super(ac);
    }
    
    public Object invoke( MethodInvocation invocation ) {
        Interaction interaction = (Interaction) invocation;
        Object ret = proceed(interaction);
 		HibernateHelper helper = HibernateHelper.getInstance();
		helper.closeSessionAndCommitTx();
		return ret;
    }

	public Object construct(ConstructorInvocation invocation)
		throws Throwable {
		throw new Exception("Ce wrapper ne supporte pas le wrapping de constructeur");
	}	
}
