// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.hibernate;

import org.objectweb.jac.core.AspectComponent;

/**
 * Classe permettant la configuration des diffrents wrappers
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class HibernateAC extends AspectComponent {
    private HibernateHelper helper = HibernateHelper.getInstance();
	    
    public void registerPersistentClass(String className,String primaryKey) throws ClassNotFoundException {    
        Class cl = Class.forName(className);
        PersistentClassWrapper wrapper = new PersistentClassWrapper(this,primaryKey);
        pointcut("ALL",className,"CONSTRUCTORS",wrapper,"exceptionHandler");
        pointcut("ALL",className,"delete()||save()",wrapper,"exceptionHandler");
        helper.addClass(cl);
    }

	public void delimitPersistentSession(
	    String beginClassExpr, String beginObjExpr, String beginMethodExpr,
	    String endClassExpr, String endObjExpr, String endMethodExpr ) {
	        
	    BeginPersistentSessionWrapper beginwrapper =
	        new BeginPersistentSessionWrapper(this);
	    
	    EndPersistentSessionWrapper endwrapper =
            new EndPersistentSessionWrapper(this);
            
	    pointcut( beginObjExpr, beginClassExpr, beginMethodExpr, beginwrapper,null);
	    pointcut( endObjExpr, endClassExpr, endMethodExpr, endwrapper,null);
	}
    
}
