// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.persistence;

import java.util.Set;
import aop.as.hibernate.Persistent;

/**
 * Classe reprsentant un client
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Customer implements Persistent {
	private int id;
	private String name;
	private String firstname;
	private String address;
	private Set orders;
	
	public Customer(){
	}
	
	public Customer(int id) {
		this.id = id;
	}
	
	void setOrders(Set orders) {
	   this.orders = orders;
	}

	public Set getOrders() {
	   return orders;
	}

	public void addOrder(Order order) {
	   orders.add(order);
	}
	
	public String getAddress() {
		return address;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getFirstname() {
		return firstname;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public void setId(int id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setFirstname(String surname) {
		this.firstname = surname;
	}
	
	public void delete() {
	}

	public void save() {
	}
}
