// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 3 : AspectJ                                     -
// ------------------------------------------------------------

package aop.aspectj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Dans l'application Gestion de commandes,
 * cette classe reprsente les commandes des clients.
 * Les articles commands sont ajoutes  une map. 
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Order {
    
    /** Les articles commandes. */
    private Map articles = new HashMap();
    
    /**
     * Ajout d'un article a la commande.
     * 
     * @param reference  la reference de l'article.
     * @param quantite   la quantite commande.
     */
    public void addItem( String reference, int quantite ) {
        articles.put(reference,new Integer(quantite));
        System.out.println(
            quantite+" article(s) "+reference+" ajoute(s) a la commande");
    }
    
    /**
     * Calcul du montant de la commande.
     * 
     * @return  le montant de la commande.
     */
    public double computeAmount() {
        double montant = 0.0;
        for (Iterator iter = articles.entrySet().iterator(); iter.hasNext();) {
            Map.Entry entry = (Map.Entry) iter.next();
            String article = (String) entry.getKey();
            Integer quantite = (Integer) entry.getValue();
            double prix = Catalog.getPrice(article);
            montant += prix*quantite.intValue();
        }
        return montant;
    }

}
