// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 3 : AspectJ                                     -
// ------------------------------------------------------------

package aop.aspectj;

import java.util.Date;
import java.util.Map;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect trace les appels a toutes les methodes de la classe Order.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect TraceAspect2 {
    
    /**
     * Cette coupe capture les appels a toutes les methodes de la classe Order.
     */
    pointcut toBeTraced(): call( * aop.aspectj.Order.*(..) );
    
    /**
     * Code advice qui affiche les messages de trace.
     */
    Object around(): toBeTraced() {
        System.out.println("-> Avant appel");
        Object ret = proceed();
        System.out.println("-> Apres appel");
        return ret;
    }
        
}
