// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 3 : AspectJ                                     -
// ------------------------------------------------------------

package aop.aspectj;

import java.util.Date;
import java.util.Map;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect trace les appels a toutes les methodes de la classe Order et
 * affiche des informations sur chaque point de jonction rencontre.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public aspect TraceAspect3 {
    
    /**
     * Cette coupe capture les appels a toutes les methodes de la classe Order.
     */
    pointcut toBeTraced(): call( * aop.aspectj.Order.*(..) );
    
    /**
     * Code advice qui affiche les messages de trace et
     * les informations sur l'introspection des points de jonction.
     */
    Object around(): toBeTraced() {
        
        String methodName = thisJoinPoint.getSignature().getName();
        Object[] args = thisJoinPoint.getArgs();
        Object caller = thisJoinPoint.getThis();
        Object callee = thisJoinPoint.getTarget();
                
        System.out.println("-> Debut methode "+methodName);
        System.out.print("-> "+args.length+" parametre(s) ");
        for (int i = 0; i < args.length; i++) {
            System.out.print( args[i]+" " );
        }
        System.out.println();
        System.out.println("-> "+caller+" vers "+callee);
        Object ret = proceed();
        System.out.println("<- Fin methode "+methodName);
        return ret;
    }

}
