#!/bin/sh

echo "------------------------------------------------------------"
echo "- La programmation orientee aspect pour Java/J2EE          -"
echo "- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -"
echo "- Editions Eyrolles                                        -"
echo "-                                                          -"
echo "- Partie II  : Les outils de la POA                        -"
echo "- Chapitre 4 : JAC                                         -"
echo "------------------------------------------------------------"

echo "------------------------------------------------------"
echo "- Application: Gestion de commandes                  -"
echo "- Aspect:      Trace des methodes de la classe Order -"
echo "------------------------------------------------------"

if [ -f $JAVA_HOME/bin/java ]
then
    if [ -f $JAC_HOME/jac.jar -a -f $JAC_HOME/lib/aopalliance.jar ]
    then
        echo ---- Compilation ----

	cd ../..

        "$JAVA_HOME/bin/javac" -classpath "$JAC_HOME/jac.jar:$JAC_HOME/lib/aopalliance.jar:$CLASSPATH" -d classes src/aop/jac/*.java

        echo ---- Execution ----

        "$JAVA_HOME/bin/java" -classpath "classes:$JAC_HOME/jac.jar:$CLASSPATH" org.objectweb.jac.core.Jac -R . -C classes:src customer2.jac
    else
        echo "JAC n'a pas ete trouve."
        echo "Positionner la variable d'environnement JAC_HOME dans le fichier env.sh"
    fi
else
    echo "Java n'a pas ete trouve."
    echo "Positionner la variable d'environnement JAVA_HOME dans le fichier env.sh"
fi

