// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.objectweb.jac.core.AspectComponent;

/**
 * Ce composant d'aspect introduit un gestionnaire d'exception
 * (voir ExceptionHandlerWrapper).
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class ExceptionHandlerAspect extends AspectComponent {
    
    public ExceptionHandlerAspect() {
        /**
         * Dfinition d'un gestionnaire d'exception
         * (methode myHandler de la classe ExceptionHandlerWrapper)
         * pour cette coupe.
         */
        pointcut(
            ".*", "aop.jac.GenerateExcept", "run():void",
            "aop.jac.ExceptionHandlerWrapper",
            "myHandler",false);
    }
}
