// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.objectweb.jac.core.AspectComponent;

/**
 * Dans l'application Gestion de commandes,
 * ce composant d'aspect introduit une mthode computeAmountAndPrint
 * (voir RoleMethodWrapper).
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class RoleMethodAspect extends AspectComponent {
    
    public RoleMethodAspect() {
        /**
         * Dfinition d'une coupe sur la methode addItem de la classe Order.
         * Apres l'execution de addItem, RoleMethodWrapper appelle la methode
         * introduite computeAmountAndPrint.
         */
        pointcut(
            ".*", "aop.jac.Order", "addItem.*",
            "aop.jac.RoleMethodWrapper",
            null,false);        
    }
}
