// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.objectweb.jac.core.AspectComponent;

/**
 * Dans l'application Gestion de commandes,
 * ce composant d'aspect permet de definir des coupes et
 * de tracer les executions de methodes appartenant a ces coupes
 * et d'afficher des informations d'introspection de points de jonction.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceAspect3 extends AspectComponent {
    
    /**
     * L'appel de la methode trace dans le fichier de configuration de
     * l'aspect definira une coupe a partir des trois expressions fournies.
     * Cette coupe sera associee au wrapper TraceWrapper3.
     */
    public void trace( String objectPE, String classPE, String methodPE ) {
        pointcut(
            objectPE, classPE, methodPE,
            "aop.jac.TraceWrapper3",
            null,false);        
    }
}
