// ------------------------------------------------------------
// - La programmation oriente aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 4 : JAC                                         -
// ------------------------------------------------------------

package aop.jac;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Wrapper;

/**
 * Dans l'application Gestion de commandes,
 * ce wrapper affiche les messages de trace et
 * des informations sur le point de jonction rencontre.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceWrapper3 extends Wrapper {

    public TraceWrapper3(AspectComponent ac) {
        super(ac);
    }

    /**
     * Interception des executions de constructeurs.
     */
    public Object construct(ConstructorInvocation ci) throws Throwable {
        return proceed(ci);
    }

    /**
     * Interception des executions de methodes.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        
        String methodName = mi.getMethod().getName();
        Object[] args = mi.getArguments();
        Object callee = mi.getThis();
                
        System.out.println("-> Debut methode "+methodName);
        System.out.print("-> "+args.length+" parametre(s) ");
        for (int i = 0; i < args.length; i++)
        System.out.print( args[i]+" " );
        System.out.println();
        System.out.println("-> vers "+callee);

        Object ret = proceed(mi);

        System.out.println("<- Fin methode "+methodName);
        return ret;
    }
    
}
