// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 5 : JBoss AOP                                   -
// ------------------------------------------------------------

package aop.jboss;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Dans l'application Gestion de commandes,
 * cette classe illustre l'utilisation des aspects JBoss AOP.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Aspect {

    public Object advice(Invocation invocation) throws Throwable {
       MethodInvocation mi = (MethodInvocation) invocation;      
       String methodName = mi.method.getName();         
      
       System.out.println("Avant "+methodName);
       Object rsp = mi.invokeNext();
       System.out.println("Aprs "+methodName);
       return rsp;
    }

}
