//------------------------------------------------------------
//- La programmation orientee aspect pour Java/J2EE          -
//- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
//- Editions Eyrolles                                        -
//-                                                          -
//- Partie II  : Les outils de la POA                        -
//- Chapitre 5 : JBoss AOP                                   -
//------------------------------------------------------------

package aop.jboss;

import java.util.Date;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;


/**
 * Dans l'application Gestion de commandes,
 * cet intercepteur utilise l'interface CalendarItf introduite.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class CalendarInterceptor implements Interceptor {
    
    public String getName() { return "CalendarInterceptor"; }
    
    /**
     * Mthode d'interception.
     */
    public Object invoke(Invocation invocation) throws Throwable {

        Object rsp = invocation.invokeNext();
        
        Object target = invocation.targetObject;
        Date date = ((CalendarItf)target).getDate();
        System.out.println("Date de creation de la commande "+date);
        
        return rsp;
    }

}
