// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 5 : JBoss AOP                                   -
// ------------------------------------------------------------

package aop.jboss;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Dans l'application Gestion de commandes,
 * cet intercepteur affiche les messages de trace.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class MetadataInterceptor implements Interceptor {
    public String getName() {
        return "TraceInterceptor";
    }

    /**
     * Mthode d'interception.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        
        String data = (String) invocation.getMetaData("toBeTraced","level");
        MethodInvocation mi = (MethodInvocation) invocation;
        String methodName = mi.method.getName();
        
        System.out.println(
            "-> Methode "+methodName+" metadonnee toBeTraced level = "+data);
        return invocation.invokeNext();
    }
}
