// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 5 : JBoss AOP                                   -
// ------------------------------------------------------------

package aop.jboss;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Dans l'application Gestion de commandes,
 * cet intercepteur affiche les messages de trace.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceInterceptor2 implements Interceptor {
    public String getName() {
        return "TraceInterceptor2";
    }

    /**
     * Mthode d'interception.
     */
    public Object invoke(Invocation invocation) throws Throwable {

        MethodInvocation mi = (MethodInvocation) invocation;
        String methodName = mi.method.getName();

        System.out.println("-> Avant " + methodName);
        Object rsp = invocation.invokeNext();
        System.out.println("-> Apres " + methodName);
        return rsp;
    }
}
