// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 5 : JBoss AOP                                   -
// ------------------------------------------------------------

package aop.jboss;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;


/**
 * Dans l'application Gestion de commandes,
 * cet intercepteur affiche les messages de trace et
 * des informations d'introspection de point de jonction.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceInterceptor3 implements Interceptor {    

   public String getName() { return "TraceInterceptor3"; }

   /**
    * Mthode d'interception.
    */
   public Object invoke(Invocation invocation) throws Throwable {
    
      MethodInvocation mi = (MethodInvocation) invocation;
      String methodName = mi.method.getName();
      Object[] args = mi.arguments;
      Object callee = mi.targetObject;
      
      System.out.println("-> Debut methode "+methodName);
      if ( args == null ) {
        System.out.println("-> 0 parametre ");
      }
      else {
        System.out.print("-> "+args.length+" parametre(s) ");
        for (int i = 0; i < args.length; i++)
           System.out.print( args[i]+" " );
        System.out.println();
      }
      System.out.println("-> vers "+callee);

      Object rsp = invocation.invokeNext();
      
      System.out.println("<- Fin methode "+methodName);
      return rsp;

  }
}
