// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie II  : Les outils de la POA                        -
// - Chapitre 6 : AspectWerkz                                 -
// ------------------------------------------------------------

package aop.aspectwerkz;

import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MemberSignature;

/**
 * Dans l'application Gestion de commandes,
 * cet aspect affiche les messages de trace et
 * des informations sur le point de jonction rencontre.
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class TraceAspect3 {

    public Object trace(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("-> Debut methode " + signature.getName());
        Object result = joinPoint.proceed();
        System.out.println("<- Fin methode " + signature.getName());
        return result;
    }

}
