// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.accessproxy;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique
 * d'un proxy d'accs
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractAccessProxyAspect {
	protected String user;
	protected String password;
		
	public void setAuthentication(String user,String password) {
		this.user = user;
		this.password = password;
	}
	
	protected abstract boolean isAuthorized();
	
	protected abstract pointcut accessControl();
	
	before() : accessControl() {
		if (!isAuthorized()) {
			throw new RuntimeException("Accs non autoris  la mthode "+thisJoinPoint.getSignature().getName());
		}
	}
}
