// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.observer;

import java.util.Enumeration;
import java.util.Vector;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique de  
 * l'observateur
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractObserverAspect pertarget (subject()) {
	private Vector observers = new Vector();
	
	public void addObserver(Object o) {
		observers.add(o);
	}
	
	public void removeObserver(Object o) {
		observers.remove(o);
	}
	
	protected abstract pointcut subject();
	
	protected abstract pointcut event();
	
	protected abstract void notifyEvent(Object subject,Object observer);
	
	after(Object s) : event() && target(s) {
		Enumeration elements = observers.elements();
		while (elements.hasMoreElements()) {
			Object o = elements.nextElement();
			notifyEvent(s,o);
		}
	}
}