// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.observer;

/**
 * Classe de statistiques 
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Stats {
	private int orders = 0;
	private float totalAmount = 0;
	private String status = "OK";
	
	public Stats() {
	}
	
	public Stats(String status) {
		this.status = status;
	}
	
	public int getOrders() {
		return orders;
	}

	public void incOrders() {
		orders++;
	}
	
	public float getTotalAmount() {
		return totalAmount;
	}
	
	public void addAmount(float p) {
		totalAmount+=p;
	}
	
	public String getStatus() {
		return status;
	}
	
	public void setStatus(String p) {
		status = p;
	}
	
	public void reset() {
		orders = 0;
		totalAmount = 0;
		status = "OK";
	}

}
