// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.strategy;

import java.util.Hashtable;

/**
 * Aspect abstrait correspondant au fonctionnement gnrique du  
 * design pattern strategie
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public abstract aspect AbstractStrategyAspect pertarget(receiver()){
	
	private Hashtable strategies = new Hashtable();
	
	public void setStrategy(Object c,Strategy s) {
		strategies.put(c,s);
	}
	
	protected Strategy getStrategy(Object c) {
		return (Strategy)strategies.get(c);
	}
	
	protected abstract pointcut receiver();
	
	protected abstract pointcut execute(Object c);
	
	before(Object receiver,Object context) : execute(Object) && target(receiver) && args(context) {
		Strategy strategy = getStrategy(context);
		strategy.execute(receiver);
	}
}