// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.strategy;

/**
 * Classe implmentant la stratgie par dfaut
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class DefaultSaver implements Strategy {
	
	public void execute(Object receiver) {
		Stats stats = (Stats)receiver;
		System.out.println("STATISTIQUES :");
		System.out.println("Nbre d'ordres : "+stats.getOrders());
		System.out.println("Montant total : "+stats.getTotalAmount());
		System.out.println("Statut : "+stats.getStatus());
		System.out.flush();
		System.out.close();
	}
}
