// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III : Applications de la POA                      -
// - Chapitre 8 : Design patterns et POA                      -
// ------------------------------------------------------------

package aop.patterns.strategy;

/**
 * Programme exemple
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class StrategyExample {
	public static void main(String[] args) {
		Stats stats = new Stats();
		
		StrategyAspect.aspectOf(stats).setStrategy("file",new FileSaver("c://temp/statistics.txt"));
		StrategyAspect.aspectOf(stats).setStrategy("default",new DefaultSaver());
		
		stats.incOrders();
		stats.addAmount(10);
		stats.incOrders();
		stats.addAmount(10);
		stats.incOrders();
		stats.addAmount(10);
		
		stats.display("default");
	}
}
