#!/bin/sh

echo "------------------------------------------------------------"
echo "- La programmation orientee aspect pour Java/J2EE          -"
echo "- Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -"
echo "- Editions Eyrolles                                        -"
echo "-                                                          -"
echo "- Partie III  : Applications de la POA                        -"
echo "- Chapitre 9 : Qualite de service des applications et POA                                         -"
echo "------------------------------------------------------------"

echo "--------------------------------------------"
echo "- Application: JMXExample        -"
echo "- Aspect:      JMX Mix-in -"
echo "--------------------------------------------"

if [ -f $JAVA_HOME/bin/java ]
then
    if [ -f $JBOSSAOP_HOME/jboss-aop.jar ]
    then
        echo ---- Compilation ----

	cd ../..

        "$JAVA_HOME/bin/javac" -classpath "$JBOSSAOP_HOME/jboss-aop.jar:$JBOSSAOP_HOME/javassist.jar:$JBOSSAOP_HOME/jboss-common.jar:$JBOSSAOP_HOME/trove.jar:$JBOSSAOP_HOME/concurrent.jar:$JBOSSAOP_HOME/qdox.jar:$CLASSPATH" -d classes src/aop/management/jmx/mixin/*.java

        echo ---- Execution ----

        "$JAVA_HOME/bin/java" -classpath "classes:src:$JBOSSAOP_HOME/jboss-aop.jar:$JBOSSAOP_HOME/javassist.jar:$JBOSSAOP_HOME/jboss-common.jar:$JBOSSAOP_HOME/trove.jar:$JBOSSAOP_HOME/concurrent.jar:$JBOSSAOP_HOME/qdox.jar:$CLASSPATH"  -Djava.system.class.loader=org.jboss.aop.standalone.SystemClassLoader aop.management.jmx.mixin.JMXExample
    else
        echo "JBoss AOP n'a pas ete trouve."
        echo "Positionner la variable d'environnement JBOSSAOP_HOME dans le fichier env.sh"
    fi
else
    echo "Java n'a pas ete trouve."
    echo "Positionner la variable d'environnement JAVA_HOME dans le fichier env.sh"
fi
