package aop.contracts.postconditions;

import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class PostConditionInterceptor1 implements Interceptor {

	public String getName() {
		return "PostConditionInterceptor1";
	}

	public Object invoke(Invocation invocation) throws Throwable {
		Object rsp = invocation.invokeNext();

		MethodInvocation methodInvocation = (MethodInvocation)invocation;
		Method method = methodInvocation.getMethod();
		Double result = (Double) rsp;
		if (result.doubleValue() < 0) {
			StringBuffer errorMsg = new StringBuffer();
			errorMsg.append("Litige sur la post-condition de la mthode sqrt. Le rsultat obtenu est ngatif (");
			errorMsg.append(result);
			errorMsg.append(").");
			throw new Error(errorMsg.toString());
		}
		return rsp;
	}
}
