package aop.contracts.postconditions;

import java.lang.reflect.Method;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class PostConditionInterceptor2 implements Interceptor {

	public String getName() {
		return "PostConditionInterceptor2";
	}

	public Object invoke(Invocation invocation) throws Throwable {
		int incrementParameterValue = 0;

		MethodInvocation methodInvocation = (MethodInvocation)invocation;
		Method method = methodInvocation.getMethod();
		incrementParameterValue =
		  ((Integer) methodInvocation.getArguments()[0]).intValue();

		Object rsp = invocation.invokeNext();

		int result = ((Integer) rsp).intValue();
		if (result != (incrementParameterValue + 1)) {
			StringBuffer errorMsg = new StringBuffer();
			errorMsg.append(
				"Litige sur la post-condition de la mthode increment. Le rsultat obtenu(");
			errorMsg.append(result);
			errorMsg.append(
				") n'est pas gal  une incrmentation de 1 du paramtre pass  la mthode (");
			errorMsg.append(incrementParameterValue);
			errorMsg.append(").");
			throw new Error(errorMsg.toString());
		}
		return rsp;
	}
}
