// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.calculator;

import java.math.*;

/**
 * Classe implmentant une calculatrice simpliste
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class Calculator {
	
	private float value;
	
	public Calculator() {
		value = 0;
	}
	
	public void reset(){
		value = 0;
	}
	
	public void add(float number) {
		value+=number;
	}
	
	public void sub(float number) {
		value-=number;
	}
	
	public void mult(float number) {
		value*=number;
	}
	
	public void div(float number) {
		if (number!=0) {
			value/=number;
		}
	}
	
	public void sqrt() {
		if (value>=0) {
			value = mysqrt(value);
		}
	}
	
	public float mysqrt(float number) {
		System.out.println("Appel de mysqrt");
		return (float)Math.sqrt(number);
	}

	public float getValue() {
		return value;
	}

	public void setValue(float value) {
		this.value = value;
	}
}
