// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.hibernate;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Interaction;
import org.objectweb.jac.core.Wrapper;
import org.objectweb.jac.core.Wrappee;

/**
 * Wrapper grant le chargement, la suppression et l'enregistrement
 * des objets persistants
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class PersistentClassWrapper extends Wrapper {
    
    private String primaryKey;
    private HibernateHelper helper = HibernateHelper.getInstance();
    
    public PersistentClassWrapper(AspectComponent ac,String primaryKey) {
        super(ac);
        this.primaryKey = primaryKey;
    }

    public Object construct(ConstructorInvocation invocation) {
    	Interaction interaction = (Interaction) invocation;
		Object ret = proceed(interaction);
		
		if (invocation.getArguments().length>0) {
			Object pkValue = null;
			try {
				Method method = interaction.wrappee.getClass().getDeclaredMethod(primaryKey,null);
				pkValue = method.invoke(interaction.wrappee,null);
				if (pkValue!=null) {
					helper.load(interaction.wrappee,pkValue);
				}
			}
			catch(NoSuchMethodException nsme) {
				throw new RuntimeException("La cl primaire est incorrecte : "+interaction.wrappee.getClass().getName());
			}
			catch(IllegalAccessException iae){
				throw new RuntimeException(iae.getMessage());
			}
			catch(InvocationTargetException ite){
				throw new RuntimeException(ite.getMessage());
			}
		}
		return ret;
    }

    
	public Object invoke( MethodInvocation invocation ) {
		Interaction interaction = (Interaction) invocation;
		String methodName = interaction.getMethod().getName();
		if (methodName.equals("save")) {
			helper.save(interaction.wrappee);	
		} else if (methodName.equals("delete")) {
			helper.delete(interaction.wrappee);
		}	
		return null;
	}
	
	public Object exceptionHandler(Exception e) throws Exception {
		helper.closeSessionAndRollbackTx();
		throw e;
	}
}
