// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.as.persistence;

import java.util.HashSet;
import java.util.Iterator;

/**
 * Programme exemple
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class PersistenceExample {

	public void run() {
		try {
			Customer c1 = new Customer();
			c1.setName("Didier");
			c1.setFirstname("Martin");
			c1.setAddress("Saint Maur");
			c1.setOrders(new HashSet());
			
			Order o1 = new Order();
			o1.setItem("DVD");
			o1.setQuantity(1);
			o1.setCustomer(c1);
			c1.addOrder(o1);
			
			Order o2 = new Order();
			o2.setItem("CD");
			o2.setQuantity(10);
			o2.setCustomer(c1);
			c1.addOrder(o2);
			
			o1.save();
			o2.save();
			c1.save();

			Customer dummy = new Customer();
			dummy.setName("Dupont");
			dummy.setFirstname("Emile");
			dummy.setAddress("Alenon");
			dummy.save();
			dummy.delete();
			
			Customer n34 = new Customer(34);
			System.out.println("Nom : "+n34.getName());
			System.out.println("Prnom : "+n34.getFirstname());
			System.out.println("Adresse : "+n34.getAddress());
			Iterator iterator = n34.getOrders().iterator();
			while (iterator.hasNext()) {
				Order o = (Order)iterator.next();
				System.out.println("---");
				System.out.println("Objet : "+o.getItem());
				System.out.println("Quantit : "+o.getQuantity());
			}
			
		}
		catch (Exception e) {
			e.printStackTrace();	
		}
	}
	
	public static void main(String[] args) {
		PersistenceExample t = new PersistenceExample();
		t.run();
	}
}
