// ------------------------------------------------------------
// - La programmation orientee aspect pour Java/J2EE          -
// - Renaud Pawlak, Jean-Philippe Retaille, Lionel Seinturier -
// - Editions Eyrolles                                        -
// -                                                          -
// - Partie III  : Applications de la POA                     -
// - Chapitre 10 : Serveurs d'applications et POA             -
// ------------------------------------------------------------

package aop.patterns.singleton;

import org.aopalliance.intercept.ConstructorInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.jac.core.AspectComponent;
import org.objectweb.jac.core.Interaction;
import org.objectweb.jac.core.Wrapper;

/**
 * Implmentation de la prcondition
 * 
 * @author Renaud Pawlak
 * @author Jean-Philippe Retaille
 * @author Lionel Seinturier
 */
public class SingletonWrapper extends Wrapper {
	
	private boolean instanciated = false;
	
	public SingletonWrapper(AspectComponent ac) {
		super(ac);
	}
	
	public Object construct(ConstructorInvocation invocation) throws Throwable {
		if (instanciated) {
			throw new RuntimeException("Le singleton est dj instanci !");	
		}
		instanciated = true;
		return proceed(invocation);
	}
	
	public Object invoke(MethodInvocation invocation) throws Throwable {
		throw new Exception("Ce wrapper ne supporte pas le wrapping de mthode");
	}
}
