import sys
import os
cwd = os.getcwd()
sys.path.insert(0, cwd+os.sep+".."+os.sep)

import histogrammes as hist

from corriges.gaussien import *

import scipy

import pandas

input_file = ".." + os.sep + "SBF250.xls"

x = pandas.read_excel(input_file)

cac = x["FRCAC40"]

f_cac = [c for c in cac if not(pandas.isnull(c))]
f_cac = scipy.array(f_cac)

n = len(f_cac) # taille d'echantillon

hist.histogramme(f_cac, "histogramme des rentabilites du CAC40")

n_post = 1000 # nombre de tirages suivant la loi a posteriori
# Simulation loi a posteriori normale inverse-chi2
hyper_param = [0., 1., 2, 1.]
p = list(map(lambda r:rpost_norm_invchi2(f_cac,
               hyper_param), range(n_post)))
p = scipy.array(p)

hist.histogramme(p[:,0], "histogramme de l'esperance a posteriori")
hist.histogramme(p[:,1], "histogramme de l'ecart-type a posteriori")