import sys

import os

cwd = os.getcwd()

sys.path.insert(0, cwd)

import pathlib

sys.path.insert(0, str(pathlib.Path(cwd).parent))

sys.path.insert(0, cwd+os.sep+".."+os.sep+".."+os.sep)

import histogrammes as hist

from corriges.gaussien import *

from corriges.melanges import *

import scipy

# theta[i]: parametres (esperance, ecart-type) pour le cluster i

theta = [[7., 2.**2],[-10., 3.**2]]

# Simulation du jeu de données

n1 = 200 # Nombre d'individus du cluster 1

n2 = 300 # Nombre d'individus du cluster 2

# Simulation des donnees du cluster 1

x = x_sim_norm(200, theta[0]) 

# Simulation des donnees du cluster 2

x +=  x_sim_norm(300, theta[1])


hist.histogramme(x, "histogramme du jeu de donnees simule")


z = z_posteriori(x, theta, densite_norm)

z[190:210]

nit = 1000 # Nombre d'iterations

lambda0 = [[-1., 1],[1., 1]] # Valeur initiale des parametres


# Hyperparametres (loi a priori normale inverse-chi2)

# On prend ici les memes hyperparametres pour les deux gaussiennes

hyper_param = [0., 1., 2, 1.]    

n = len(x) # taille d'echantillon 

nit = 40  # 00 # nombre d'iterations

K = len(theta) # nombre d'etats du melange

# Echantillonneur de Gibbs

mcmc = gibbs(nit, x, theta, densite_norm, x_sim_norm,
             rpost_norm_invchi2, hyper_param)


# En sortie : labels des individus, loi predictive, estimation des proportions,

# 

z, xpred, propnaive, tri_prop, lambdap, tri = mcmc

burn = 200 # burn-in, nombre de premieres observations a enlever



hist.histogramme(x)

hist.histogramme(xpred[burn:])

hist.histogramme(propnaive[burn:,1])

lambdap = scipy.array(lambdap)

hist.histogramme(lambdap[burn:,0,0])

hist.histogramme(lambdap[burn:,0,1])

hist.histogramme(lambdap[burn:,1,0])

hist.histogramme(lambdap[burn:,1,1])





