package net.webstock;

import net.webstock.*;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityHome;

@Name("articleHome")
public class ArticleHome extends EntityHome<Article> {

	@In(create = true)
	CategorieHome categorieHome;
	@In(create = true)
	FournisseurHome fournisseurHome;

	public void setArticleArticleid(String id) {
		setId(id);
	}

	public String getArticleArticleid() {
		return (String) getId();
	}

	@Override
	protected Article createInstance() {
		Article article = new Article();
		return article;
	}

	public void wire() {
		Categorie categorie = categorieHome.getDefinedInstance();
		if (categorie != null) {
			getInstance().setCategorie(categorie);
		}
		Fournisseur fournisseur = fournisseurHome.getDefinedInstance();
		if (fournisseur != null) {
			getInstance().setFournisseur(fournisseur);
		}
	}

	public boolean isWired() {
		return true;
	}

	public Article getDefinedInstance() {
		return isIdDefined() ? getInstance() : null;
	}

	public List<Inventaire> getInventaires() {
		return getInstance() == null ? null : new ArrayList<Inventaire>(
				getInstance().getInventaires());
	}

}
