package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("articleList")
public class ArticleList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(article.articleid) like concat(lower(#{articleList.article.articleid}),'%')",
			"lower(article.nomarticle) like concat(lower(#{articleList.article.nomarticle}),'%')",
			"lower(article.description) like concat(lower(#{articleList.article.description}),'%')",
			"lower(article.imageUrl) like concat(lower(#{articleList.article.imageUrl}),'%')",};

	private Article article = new Article();

	@Override
	public String getEjbql() {
		return "select article from Article article";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Article getArticle() {
		return article;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
