package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("categorieList")
public class CategorieList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(categorie.articlecategorieid) like concat(lower(#{categorieList.categorie.articlecategorieid}),'%')",
			"lower(categorie.articlecategorie) like concat(lower(#{categorieList.categorie.articlecategorie}),'%')",};

	private Categorie categorie = new Categorie();

	@Override
	public String getEjbql() {
		return "select categorie from Categorie categorie";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Categorie getCategorie() {
		return categorie;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
