package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityHome;

@Name("clientHome")
public class ClientHome extends EntityHome<Client> {

	@In(create = true)
	WebstockaccessHome webstockaccessHome;

	public void setClientClientid(String id) {
		setId(id);
	}

	public String getClientClientid() {
		return (String) getId();
	}

	@Override
	protected Client createInstance() {
		Client client = new Client();
		return client;
	}

	public void wire() {
		Webstockaccess webstockaccess = webstockaccessHome.getDefinedInstance();
		if (webstockaccess != null) {
			getInstance().setWebstockaccess(webstockaccess);
		}
	}

	public boolean isWired() {
		return true;
	}

	public Client getDefinedInstance() {
		return isIdDefined() ? getInstance() : null;
	}

}
