package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("employeList")
public class EmployeList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(employe.employeid) like concat(lower(#{employeList.employe.employeid}),'%')",
			"lower(employe.employenom) like concat(lower(#{employeList.employe.employenom}),'%')",
			"lower(employe.employeprenom) like concat(lower(#{employeList.employe.employeprenom}),'%')",
			"lower(employe.adresse) like concat(lower(#{employeList.employe.adresse}),'%')",};

	private Employe employe = new Employe();

	@Override
	public String getEjbql() {
		return "select employe from Employe employe";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Employe getEmploye() {
		return employe;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
