package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityHome;

@Name("inventaireHome")
public class InventaireHome extends EntityHome<Inventaire> {

	@In(create = true)
	ArticleHome articleHome;

	public void setInventaireNumeroinventaire(Double id) {
		setId(id);
	}

	public Double getInventaireNumeroinventaire() {
		return (Double) getId();
	}

	@Override
	protected Inventaire createInstance() {
		Inventaire inventaire = new Inventaire();
		return inventaire;
	}

	public void wire() {
		Article article = articleHome.getDefinedInstance();
		if (article != null) {
			getInstance().setArticle(article);
		}
	}

	public boolean isWired() {
		return true;
	}

	public Inventaire getDefinedInstance() {
		return isIdDefined() ? getInstance() : null;
	}

}
