package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("clientList")
public class ClientList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(client.clientid) like concat(lower(#{clientList.client.clientid}),'%')",
			"lower(client.clientnom) like concat(lower(#{clientList.client.clientnom}),'%')",
			"lower(client.clientprenom) like concat(lower(#{clientList.client.clientprenom}),'%')",
			"lower(client.adresse) like concat(lower(#{clientList.client.adresse}),'%')",
			"lower(client.tel) like concat(lower(#{clientList.client.tel}),'%')",
			"lower(client.comment) like concat(lower(#{clientList.client.comment}),'%')",};

	private Client client = new Client();

	@Override
	public String getEjbql() {
		return "select client from Client client";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Client getClient() {
		return client;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
