package net.webstock;

import net.webstock.*;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityHome;

@Name("fournisseurHome")
public class FournisseurHome extends EntityHome<Fournisseur> {

	@In(create = true)
	WebstockaccessHome webstockaccessHome;

	public void setFournisseurFournisseurid(String id) {
		setId(id);
	}

	public String getFournisseurFournisseurid() {
		return (String) getId();
	}

	@Override
	protected Fournisseur createInstance() {
		Fournisseur fournisseur = new Fournisseur();
		return fournisseur;
	}

	public void wire() {
		Webstockaccess webstockaccess = webstockaccessHome.getDefinedInstance();
		if (webstockaccess != null) {
			getInstance().setWebstockaccess(webstockaccess);
		}
	}

	public boolean isWired() {
		if (getInstance().getWebstockaccess() == null)
			return false;
		return true;
	}

	public Fournisseur getDefinedInstance() {
		return isIdDefined() ? getInstance() : null;
	}

	public List<Article> getArticles() {
		return getInstance() == null ? null : new ArrayList<Article>(
				getInstance().getArticles());
	}

}
