package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("fournisseurList")
public class FournisseurList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(fournisseur.fournisseurid) like concat(lower(#{fournisseurList.fournisseur.fournisseurid}),'%')",
			"lower(fournisseur.fournisseurnom) like concat(lower(#{fournisseurList.fournisseur.fournisseurnom}),'%')",
			"lower(fournisseur.fournisseurprenom) like concat(lower(#{fournisseurList.fournisseur.fournisseurprenom}),'%')",
			"lower(fournisseur.adresse) like concat(lower(#{fournisseurList.fournisseur.adresse}),'%')",};

	private Fournisseur fournisseur = new Fournisseur();

	@Override
	public String getEjbql() {
		return "select fournisseur from Fournisseur fournisseur";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Fournisseur getFournisseur() {
		return fournisseur;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
