package net.webstock;

import net.webstock.*;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.framework.EntityQuery;
import java.util.List;
import java.util.Arrays;

@Name("inventaireList")
public class InventaireList extends EntityQuery {

	private static final String[] RESTRICTIONS = {
			"lower(inventaire.rayon) like concat(lower(#{inventaireList.inventaire.rayon}),'%')",
			"lower(inventaire.region) like concat(lower(#{inventaireList.inventaire.region}),'%')",};

	private Inventaire inventaire = new Inventaire();

	@Override
	public String getEjbql() {
		return "select inventaire from Inventaire inventaire";
	}

	@Override
	public Integer getMaxResults() {
		return 25;
	}

	public Inventaire getInventaire() {
		return inventaire;
	}

	@Override
	public List<String> getRestrictions() {
		return Arrays.asList(RESTRICTIONS);
	}

}
